/****************************************************************************************/
/**
  Copyright (c) 2008 Freescale Semiconductor
  Freescale Confidential Proprietary
  \file     	Adc_Cfg.h
  \brief    	This file contains all ADC configuration structures
  \author   	Freescale Semiconductor
  \author     r01160
  \author   	Guadalajara Applications Laboratory RTAC Americas
  \version    0.1
  \date     	6/27/2008 9:56:17 AM
  
  * History:
  
*/
/****************************************************************************************/
#ifndef __ADC_CFG_H__
 #define __ADC_CFG_H__

 #include "Adc.h"
 #include "Derivative.h"
 /*------------- Defines --------------------------------------------------------------*/
 /** Maximum Commands allowed to be configured                     */
 #define MAX_CMDS_ALLOWED            ((uint8_t)4)
 /** Maximum configuration parameters allowed to be configured     */
 #define MAX_CONFIG_PARAMS           ((uint8_t)2)
 /** This parameter indicates the amount of ADC channels that should be configured */
 #define MAX_ADC_CHANNELS            ((uint8_t)4)
 /** This definition helps to establish which configuration shall be used to configure \n
     ADC0 module. The Configuration value is taken from "au32Adc_Configuration_Params" \n
     array
  */
 #define ADC_ASSIGNED_CONFIG_PARAMS  ((uint8_t)0)
 /** points to: Message Tag = RFIFO 0, 8 Sampling Cycles, Format = unsigned right justification */
 #define ADC_ASSIGNED_CNTRL_CMD      ((uint8_t)0)

 
 /** ADC Clock Prescaler Options                      */
 #define ADC_CLK_4_PRESCALER       ((uint32_t)0x01)
 #define ADC_CLK_8_PRESCALER       ((uint32_t)0x03)
 #define ADC_CLK_16_PRESCALER      ((uint32_t)0x07)
 /** Enables EOQ bit in ADC Command register          */
 #define ADC_EOQ_ENABLED         ((uint32_t)0x80000000)
 /*--------- eDMA Channels assigned to ADC module (CFIFO & RFIFO) --------------------*/
 /** eDMA channel assigned to handle CFIFO command transfers */
 #define ADC_CFIFO_DMA_CHANNEL     ((uint8_t)0)
 /** eDMA channel assigned to handle RFIFO data transfers */
 #define ADC_RFIFO_DMA_CHANNEL     ((uint8_t)1) 
 
 /*--------- ADC0 Registers ----------------------------------------------------------*/
 /** ADC0 Control Register Address                    */
 #define ADC0_CR_REG             ((uint32_t)0x01) 
 /** ADC0 time Stamp Register Address                 */
 #define ADC0_TSCR_REG           ((uint32_t)0x02) 
 /** ADC0 Time Base Counter Register Address          */
 #define ADC0_TBCR_REG           ((uint32_t)0x03) 
 /** ADC0 Gain Calibration Constant Register Address  */
 #define ADC0_GCCR_REG           ((uint32_t)0x04) 
 /** ADC0 Offset Calibration Constant Register Address */
 #define ADC0_OCCR_REG           ((uint32_t)0x05) 
 
 /*--------- ADC CONVERT REGISTER FIELDS ----------------------------------------------*/
 /** Indicates to ADC where the conversion result shall be stored (RFIFO 0 - 5) */
 #define MESSAGE_TAG_0           ((uint32_t)0x00000000) 
 #define MESSAGE_TAG_1           ((uint32_t)0x00100000)
 #define MESSAGE_TAG_2           ((uint32_t)0x00200000)
 #define MESSAGE_TAG_3           ((uint32_t)0x00300000)
 #define MESSAGE_TAG_4           ((uint32_t)0x00400000)
 #define MESSAGE_TAG_5           ((uint32_t)0x00500000)
 /*--------- ADC Sampling Time definitions ---------------------------------------------*/
 /** Define Two sampling cycles for ADC measurement   */
 #define ADC_2_SAMPLING_CYCLES   ((uint32_t)0x00000000)
 /** Define Eight sampling cycles for ADC measurement */
 #define ADC_8_SAMPLING_CYCLES   ((uint32_t)0x00040000)
 /** Define 64 sampling cycles for ADC measurement    */
 #define ADC_64_SAMPLING_CYCLES  ((uint32_t)0x00080000)
 /** Define 128 sampling cycles for ADC measurement   */
 #define ADC_128_SAMPLING_CYCLES ((uint32_t)0x000C0000)
 /*--------- ADC Conversion Data Format definitions -----------------------------------*/
 /** specifies how to format the 12-bit conversion data*/
 #define ADC_FMT_UNSIGNED_RIGHT  ((uint32_t)0x00000000) 
 #define ADC_FMT_SIGNED_RIGHT    ((uint32_t)0x00010000) 
 /*--------- ADC CONTROL COMMANDS ------------------------------------------------------*/
 /** Enables ADC Operating mode to single scan        */
 #define ADC_SINGLE_SCAN_MODE    ((uint16_t)0x0010)
 /** Enables Single-Scan bit on CFCR register         */
 #define ADC_SEE_ENABLE_BIT      ((uint16_t)0x0400)
 
 /*-------------------------------------------------------------------------------------*/
 /** Configures Long sampling time in ADC clock cycles */
 #define ADC_LONG_SAMPLE_TIME    ((uint32_t)(ADC_8_SAMPLING_CYCLES))
 /*------------- ADC CHANNELS ----------------------------------------------------------*/
 #define ADC_CHANNEL_0        ((uint8_t)0x00)
 #define ADC_CHANNEL_1        ((uint8_t)0x01)
 #define ADC_CHANNEL_2        ((uint8_t)0x02)
 #define ADC_CHANNEL_3        ((uint8_t)0x03)
 #define ADC_CHANNEL_4        ((uint8_t)0x04)
 #define ADC_CHANNEL_5        ((uint8_t)0x05)
 #define ADC_CHANNEL_6        ((uint8_t)0x06)
 #define ADC_CHANNEL_7        ((uint8_t)0x07)
 #define ADC_CHANNEL_8        ((uint8_t)0x08)
 #define ADC_CHANNEL_9        ((uint8_t)0x09) 
 
 #define ADC_CHANNEL_28        ((uint8_t)0x1C)
 #define ADC_CHANNEL_29        ((uint8_t)0x1D)
 #define ADC_CHANNEL_30        ((uint8_t)0x1E)
 #define ADC_CHANNEL_31        ((uint8_t)0x1F)
 #define ADC_CHANNEL_32        ((uint8_t)0x20)
 #define ADC_CHANNEL_33        ((uint8_t)0x21)
 #define ADC_CHANNEL_34        ((uint8_t)0x22)
 #define ADC_CHANNEL_35        ((uint8_t)0x23)
 #define ADC_CHANNEL_36        ((uint8_t)0x24)
 #define ADC_CHANNEL_37        ((uint8_t)0x25) 
 
 
 
 /** ADC Reference channels - 75% and 25% */
 #define ADC_75_REF_CHANNEL   ((uint8_t)0x2B) 
 #define ADC_25_REF_CHANNEL   ((uint8_t)0x2C) 
 /** Enables pr Disables Calibration after ADC Conversion */
 #define ADC_CAL_ENABLE       ((uint32_t)0x01000000)
 #define ADC_CAL_DISABLE      ((uint32_t)0x00000000)
 /*--------------------------------------------------------------------------------------*/
 /*------------- ADC CHANNELS ----------------------------------------------------------*/
 /** Result FIFO buffer numbers (0-5) */
 #define ADC_FIFO_BUFFER_0    ((uint8_t)0x00)
 #define ADC_FIFO_BUFFER_1    ((uint8_t)0x01)
 #define ADC_FIFO_BUFFER_2    ((uint8_t)0x02)
 #define ADC_FIFO_BUFFER_3    ((uint8_t)0x03)
 #define ADC_FIFO_BUFFER_4    ((uint8_t)0x04)
 #define ADC_FIFO_BUFFER_5    ((uint8_t)0x05)
 
 /** Holds the Adc FIFO buffer to be used by the driver */
 #define ADC_FIFO_BUFFER      ((uint8_t) ADC_FIFO_BUFFER_0)
 
 /*------------- ADC calibration Values --------------------------------------------------*/
 /** Adc Reference Calibration Voltages            */
 #define ADC_IDEAL_RES75      ((uint32_t)(0x00003000))
 #define ADC_IDEAL_RES25      ((uint32_t)(0x00001000))
 /*****************************************************************************************/
 /*                  ADC CONFIGURATION , CONTROL AND CONVERSION VALUES                    */
 /*                                                                                       */
 /*****************************************************************************************/ 
 /*------------- CONFIGURATION COMMAND MESSAGES -----------------------------------------*/
  /** Configuration Command 1: ADC PS = 16 -> ADC Clock = 4 MHz, ADC0 Enabled, Write to Configuration Control Register */
  #define ADC_CONFIGURATION_1  ((uint32_t)((uint32_t)0x80800000 | (uint32_t)(ADC_CLK_16_PRESCALER << 8) | (uint32_t)ADC0_CR_REG))
  /** Configuration Command 2: ADC PS = 16 -> ADC Clock = 4 MHz, ADC0 Enabled, Write to Configuration Control Register */
  #define ADC_CONFIGURATION_2  ((uint32_t)((uint32_t)0x80800000 | (uint32_t)(ADC_CLK_4_PRESCALER << 8) | (uint32_t)ADC0_CR_REG))
  #define ADC_CONFIGURATION_3  (uint32_t)0x80800701
  //0x80801001
  
  /*--------------------------------------------------------------------------------------*/
 
 /*------------- CONVERSION COMMAND MESSAGES --------------------------------------------*/
 /** These definitions hold the Conversion Command Messages */
 /* Message Tag = RFIFO 0, 8 Sampling Cycles, Format = unsigned right justification */
 #define ADC_CONV_CMD_1_FIFO_0       ((uint32_t)((uint32_t)ADC_EOQ_ENABLED | (uint32_t)(MESSAGE_TAG_0) | (uint32_t)(ADC_8_SAMPLING_CYCLES)))
 /* Message Tag = RFIFO 0, 2 Sampling Cycles, Format = unsigned right justification */
 #define ADC_CONV_CMD_2_FIFO_0       ((uint32_t)((uint32_t)ADC_EOQ_ENABLED | (uint32_t)(MESSAGE_TAG_0) | (uint32_t)(ADC_2_SAMPLING_CYCLES)))
 /* Message Tag = RFIFO 1, 2 Sampling Cycles, Format = unsigned right justification */
 #define ADC_CONV_CMD_3_FIFO_1       ((uint32_t)((uint32_t)ADC_EOQ_ENABLED | (uint32_t)(MESSAGE_TAG_1) | (uint32_t)(ADC_8_SAMPLING_CYCLES)))
/* Message Tag = RFIFO 1, CAL = 1, 8 Sampling Cycles, Format = unsigned right justification */
 #define ADC_CONV_CMD_4_FIFO_1       ((uint32_t)((uint32_t)0x81000000 | (uint32_t)(MESSAGE_TAG_1) | (uint32_t)(ADC_8_SAMPLING_CYCLES)))
 
 
 /*---------------------------------------------------------------------------------------*/
 /*------------- CONTROL PARAMETERS -----------------------------------------------------*/
 /** This definition holds the parameters to indicate how a CFIFO shall work \n
     Mode: Single Scan , Tigger: Software , SSS bit: Enabled                       */
 #define ADC_CTRL_CMD_1      ((uint16_t) (ADC_SINGLE_SCAN_MODE | ADC_SEE_ENABLE_BIT))
 
 /*------------- External variables -----------------------------------------------------*/
 extern uint32_t au32Adc_Config_Params[MAX_CONFIG_PARAMS];
 extern uint32_t au32Adc_Conversion_Params[MAX_CMDS_ALLOWED];
 extern uint8_t au8Adc_Port_Pins[MAX_ADC_CHANNELS];
 
 /*--------------------------------------------------------------------------------------*/
 
 
#endif
